#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;

using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

#endregion

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Class SpecialInstructionsDisplayPanel
	/// </summary>
	public class SpecialInstructionsDisplayPanel : GUI.controls.BaseControl
	{
		#region Variables

		private BOL.Patient _patient;

		// CR 2609
		private bool _hasTransfusionRequirementsTabData;

		#endregion

		#region Controls

		private System.Windows.Forms.TabControl tabProfile;
		private System.Windows.Forms.TabPage pageTransfusionRequirements;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel pnlComponentRequirements;
		private System.Windows.Forms.Label lblComponentAttributes;
		private System.Windows.Forms.Panel pnlAntibodiesAntigens;
		private System.Windows.Forms.Splitter splitter2;
		private System.Windows.Forms.Panel pnlAntigens;
		private System.Windows.Forms.Label lblAntigenNegativeScreens;
		private System.Windows.Forms.Panel pnlAntibodies;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TabPage pageSpecialInstructions;
		private System.Windows.Forms.Label lblSpecialInstructions;
		private System.Windows.Forms.Panel pnlSpecialInstructions;
		private System.Windows.Forms.RichTextBox txtSpecialInstructions;
		private System.Windows.Forms.RichTextBox txtAntigenNegativeRBCs;
		private System.Windows.Forms.RichTextBox txtAntibodies;
		private System.Windows.Forms.RichTextBox txtComponentRequirements;
		private System.Windows.Forms.HelpProvider hlpHelpChm;
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion

		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public SpecialInstructionsDisplayPanel()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
            hlpHelpChm.SetHelpKeyword(this, "Special_Instructions_and_Transfusion_Requirements__Enter_and_Remove_Special_Instructions_.htm");
            hlpHelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			//
			this.DisplayTabPages(new DataTable(),new DataTable());
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.tabProfile = new System.Windows.Forms.TabControl();
			this.pageTransfusionRequirements = new System.Windows.Forms.TabPage();
			this.pnlAntibodiesAntigens = new System.Windows.Forms.Panel();
			this.pnlAntibodies = new System.Windows.Forms.Panel();
			this.txtAntibodies = new System.Windows.Forms.RichTextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.splitter2 = new System.Windows.Forms.Splitter();
			this.pnlAntigens = new System.Windows.Forms.Panel();
			this.txtAntigenNegativeRBCs = new System.Windows.Forms.RichTextBox();
			this.lblAntigenNegativeScreens = new System.Windows.Forms.Label();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.pnlComponentRequirements = new System.Windows.Forms.Panel();
			this.txtComponentRequirements = new System.Windows.Forms.RichTextBox();
			this.lblComponentAttributes = new System.Windows.Forms.Label();
			this.pageSpecialInstructions = new System.Windows.Forms.TabPage();
			this.pnlSpecialInstructions = new System.Windows.Forms.Panel();
			this.txtSpecialInstructions = new System.Windows.Forms.RichTextBox();
			this.lblSpecialInstructions = new System.Windows.Forms.Label();
			this.hlpHelpChm = new System.Windows.Forms.HelpProvider();
			this.tabProfile.SuspendLayout();
			this.pageTransfusionRequirements.SuspendLayout();
			this.pnlAntibodiesAntigens.SuspendLayout();
			this.pnlAntibodies.SuspendLayout();
			this.pnlAntigens.SuspendLayout();
			this.pnlComponentRequirements.SuspendLayout();
			this.pageSpecialInstructions.SuspendLayout();
			this.pnlSpecialInstructions.SuspendLayout();
			this.SuspendLayout();
			// 
			// tabProfile
			// 
			this.tabProfile.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabProfile.Controls.Add(this.pageTransfusionRequirements);
			this.tabProfile.Controls.Add(this.pageSpecialInstructions);
			this.tabProfile.ItemSize = new System.Drawing.Size(136, 19);
			this.tabProfile.Location = new System.Drawing.Point(0, 0);
			this.tabProfile.Multiline = true;
			this.tabProfile.Name = "tabProfile";
			this.tabProfile.SelectedIndex = 0;
			this.tabProfile.Size = new System.Drawing.Size(288, 308);
			this.tabProfile.SizeMode = System.Windows.Forms.TabSizeMode.FillToRight;
			this.tabProfile.TabIndex = 0;
			// 
			// pageTransfusionRequirements
			// 
			this.pageTransfusionRequirements.Controls.Add(this.pnlAntibodiesAntigens);
			this.pageTransfusionRequirements.Controls.Add(this.splitter1);
			this.pageTransfusionRequirements.Controls.Add(this.pnlComponentRequirements);
			this.pageTransfusionRequirements.Location = new System.Drawing.Point(4, 23);
			this.pageTransfusionRequirements.Name = "pageTransfusionRequirements";
			this.pageTransfusionRequirements.Size = new System.Drawing.Size(280, 281);
			this.pageTransfusionRequirements.TabIndex = 4;
			this.pageTransfusionRequirements.Text = "Transfusion Requirements";
			// 
			// pnlAntibodiesAntigens
			// 
			this.pnlAntibodiesAntigens.Controls.Add(this.pnlAntibodies);
			this.pnlAntibodiesAntigens.Controls.Add(this.splitter2);
			this.pnlAntibodiesAntigens.Controls.Add(this.pnlAntigens);
			this.pnlAntibodiesAntigens.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlAntibodiesAntigens.Location = new System.Drawing.Point(0, 119);
			this.pnlAntibodiesAntigens.Name = "pnlAntibodiesAntigens";
			this.pnlAntibodiesAntigens.Size = new System.Drawing.Size(280, 162);
			this.pnlAntibodiesAntigens.TabIndex = 65;
			this.pnlAntibodiesAntigens.Resize += new System.EventHandler(this.pnlAntibodiesAntigens_Resize);
			// 
			// pnlAntibodies
			// 
			this.pnlAntibodies.Controls.Add(this.txtAntibodies);
			this.pnlAntibodies.Controls.Add(this.label1);
			this.pnlAntibodies.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlAntibodies.Location = new System.Drawing.Point(96, 0);
			this.pnlAntibodies.Name = "pnlAntibodies";
			this.pnlAntibodies.Size = new System.Drawing.Size(184, 162);
			this.pnlAntibodies.TabIndex = 2;
			// 
			// txtAntibodies
			// 
			this.txtAntibodies.AccessibleDescription = "Patient Antibodies";
			this.txtAntibodies.AccessibleName = "Patient Antibodies";
			this.txtAntibodies.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAntibodies.BackColor = System.Drawing.SystemColors.Control;
			this.txtAntibodies.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtAntibodies.Location = new System.Drawing.Point(0, 16);
			this.txtAntibodies.Name = "txtAntibodies";
			this.txtAntibodies.ReadOnly = true;
			this.txtAntibodies.Size = new System.Drawing.Size(184, 146);
			this.txtAntibodies.TabIndex = 3;
			this.txtAntibodies.Text = "";
			// 
			// label1
			// 
			this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.label1.Location = new System.Drawing.Point(0, 0);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(184, 16);
			this.label1.TabIndex = 67;
			this.label1.Text = "Patient Antibodies";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// splitter2
			// 
			this.splitter2.Location = new System.Drawing.Point(92, 0);
			this.splitter2.Name = "splitter2";
			this.splitter2.Size = new System.Drawing.Size(4, 162);
			this.splitter2.TabIndex = 1;
			this.splitter2.TabStop = false;
			// 
			// pnlAntigens
			// 
			this.pnlAntigens.Controls.Add(this.txtAntigenNegativeRBCs);
			this.pnlAntigens.Controls.Add(this.lblAntigenNegativeScreens);
			this.pnlAntigens.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlAntigens.Location = new System.Drawing.Point(0, 0);
			this.pnlAntigens.Name = "pnlAntigens";
			this.pnlAntigens.Size = new System.Drawing.Size(92, 162);
			this.pnlAntigens.TabIndex = 0;
			// 
			// txtAntigenNegativeRBCs
			// 
			this.txtAntigenNegativeRBCs.AccessibleDescription = "Antigen Negitive R B C";
			this.txtAntigenNegativeRBCs.AccessibleName = "Antigen Negitive R B C";
			this.txtAntigenNegativeRBCs.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAntigenNegativeRBCs.BackColor = System.Drawing.SystemColors.Control;
			this.txtAntigenNegativeRBCs.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtAntigenNegativeRBCs.Location = new System.Drawing.Point(0, 16);
			this.txtAntigenNegativeRBCs.Name = "txtAntigenNegativeRBCs";
			this.txtAntigenNegativeRBCs.ReadOnly = true;
			this.txtAntigenNegativeRBCs.Size = new System.Drawing.Size(92, 146);
			this.txtAntigenNegativeRBCs.TabIndex = 2;
			this.txtAntigenNegativeRBCs.Text = "";
			// 
			// lblAntigenNegativeScreens
			// 
			this.lblAntigenNegativeScreens.Location = new System.Drawing.Point(0, 0);
			this.lblAntigenNegativeScreens.Name = "lblAntigenNegativeScreens";
			this.lblAntigenNegativeScreens.Size = new System.Drawing.Size(100, 16);
			this.lblAntigenNegativeScreens.TabIndex = 63;
			this.lblAntigenNegativeScreens.Text = "Antigen Neg. RBC";
			this.lblAntigenNegativeScreens.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// splitter1
			// 
			this.splitter1.Dock = System.Windows.Forms.DockStyle.Top;
			this.splitter1.Location = new System.Drawing.Point(0, 116);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(280, 3);
			this.splitter1.TabIndex = 64;
			this.splitter1.TabStop = false;
			// 
			// pnlComponentRequirements
			// 
			this.pnlComponentRequirements.Controls.Add(this.txtComponentRequirements);
			this.pnlComponentRequirements.Controls.Add(this.lblComponentAttributes);
			this.pnlComponentRequirements.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlComponentRequirements.Location = new System.Drawing.Point(0, 0);
			this.pnlComponentRequirements.Name = "pnlComponentRequirements";
			this.pnlComponentRequirements.Size = new System.Drawing.Size(280, 116);
			this.pnlComponentRequirements.TabIndex = 63;
			// 
			// txtComponentRequirements
			// 
			this.txtComponentRequirements.AccessibleDescription = "Component Requirements";
			this.txtComponentRequirements.AccessibleName = "Component Requirements";
			this.txtComponentRequirements.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComponentRequirements.BackColor = System.Drawing.SystemColors.Control;
			this.txtComponentRequirements.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtComponentRequirements.Location = new System.Drawing.Point(0, 16);
			this.txtComponentRequirements.Name = "txtComponentRequirements";
			this.txtComponentRequirements.ReadOnly = true;
			this.txtComponentRequirements.Size = new System.Drawing.Size(280, 95);
			this.txtComponentRequirements.TabIndex = 1;
			this.txtComponentRequirements.Text = "";
			// 
			// lblComponentAttributes
			// 
			this.lblComponentAttributes.BackColor = System.Drawing.SystemColors.Control;
			this.lblComponentAttributes.Location = new System.Drawing.Point(0, 0);
			this.lblComponentAttributes.Name = "lblComponentAttributes";
			this.lblComponentAttributes.Size = new System.Drawing.Size(280, 16);
			this.lblComponentAttributes.TabIndex = 59;
			this.lblComponentAttributes.Text = "Component Requirements";
			this.lblComponentAttributes.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pageSpecialInstructions
			// 
			this.pageSpecialInstructions.Controls.Add(this.pnlSpecialInstructions);
			this.pageSpecialInstructions.Controls.Add(this.lblSpecialInstructions);
			this.pageSpecialInstructions.Location = new System.Drawing.Point(4, 23);
			this.pageSpecialInstructions.Name = "pageSpecialInstructions";
			this.pageSpecialInstructions.Size = new System.Drawing.Size(280, 281);
			this.pageSpecialInstructions.TabIndex = 7;
			this.pageSpecialInstructions.Text = "Special Instructions";
			this.pageSpecialInstructions.Visible = false;
			// 
			// pnlSpecialInstructions
			// 
			this.pnlSpecialInstructions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlSpecialInstructions.BackColor = System.Drawing.SystemColors.Control;
			this.pnlSpecialInstructions.Controls.Add(this.txtSpecialInstructions);
			this.pnlSpecialInstructions.Location = new System.Drawing.Point(0, 20);
			this.pnlSpecialInstructions.Name = "pnlSpecialInstructions";
			this.pnlSpecialInstructions.Size = new System.Drawing.Size(280, 260);
			this.pnlSpecialInstructions.TabIndex = 53;
			// 
			// txtSpecialInstructions
			// 
			this.txtSpecialInstructions.AccessibleDescription = "Special Instructions";
			this.txtSpecialInstructions.AccessibleName = "Special Instructions";
			this.txtSpecialInstructions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecialInstructions.BackColor = System.Drawing.SystemColors.Control;
			this.txtSpecialInstructions.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtSpecialInstructions.Location = new System.Drawing.Point(2, 2);
			this.txtSpecialInstructions.Name = "txtSpecialInstructions";
			this.txtSpecialInstructions.ReadOnly = true;
			this.txtSpecialInstructions.Size = new System.Drawing.Size(274, 255);
			this.txtSpecialInstructions.TabIndex = 4;
			this.txtSpecialInstructions.Text = "";
			// 
			// lblSpecialInstructions
			// 
			this.lblSpecialInstructions.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblSpecialInstructions.BackColor = System.Drawing.SystemColors.Control;
			this.lblSpecialInstructions.Location = new System.Drawing.Point(4, 4);
			this.lblSpecialInstructions.Name = "lblSpecialInstructions";
			this.lblSpecialInstructions.Size = new System.Drawing.Size(272, 16);
			this.lblSpecialInstructions.TabIndex = 54;
			this.lblSpecialInstructions.Text = "Special Instructions";
			this.lblSpecialInstructions.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// SpecialInstructionsDisplayPanel
			// 
			this.Controls.Add(this.tabProfile);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "SpecialInstructionsDisplayPanel";
			this.Size = new System.Drawing.Size(288, 308);
			this.tabProfile.ResumeLayout(false);
			this.pageTransfusionRequirements.ResumeLayout(false);
			this.pnlAntibodiesAntigens.ResumeLayout(false);
			this.pnlAntibodies.ResumeLayout(false);
			this.pnlAntigens.ResumeLayout(false);
			this.pnlComponentRequirements.ResumeLayout(false);
			this.pageSpecialInstructions.ResumeLayout(false);
			this.pnlSpecialInstructions.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Control Events
		
		/// <summary>
		/// AntibodiesAntigens Resize Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void pnlAntibodiesAntigens_Resize(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
		}

		/// <summary>
		/// Textbox TextChanged event. If special instructions exists, use red border to highlight.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtSpecialInstructions_TextChanged(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
             //Defect 227411
            using (Font _tmpFontRegular = new Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0))))
            {
                using (Font _tmpFontBold = new Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0))))
                {
                    if (txtSpecialInstructions.Text.Length > 0)
                    {
                        txtSpecialInstructions.Font = _tmpFontBold;
                        pnlSpecialInstructions.BackColor = Color.Red;
                    }
                    else
                    {
                        txtSpecialInstructions.Font = _tmpFontRegular;
                        pnlSpecialInstructions.BackColor = Color.FromKnownColor(KnownColor.Control);
                    }
                }
            }
			
		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2003</CreationDate>
		///
		/// <summary>
		/// Override of Anchor property
		/// </summary>
		[
		Category("Layout"),
		Description("The anchor of the control"),
		Bindable(false),
		Browsable(true),
		]
		public override AnchorStyles Anchor
		{
			get { return base.Anchor; }
			set { base.Anchor = value; }
		}

		/// <summary>
		/// Get and set the value of Patient
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return this._patient;
			}
			set
			{
				this._patient = value;
				//
				if (value != null)
				{
					this.LoadTransfusionRequirements(Common.LogonUser.LogonUserDivisionCode, this._patient.TransfusionRequirements);
					this.LoadSpecialInstructions(_patient.SpecialInstructions);
					DisplayTabPages(this._patient.SpecialInstructions,this._patient.TransfusionRequirements);
				}
				else
				{
					DisplayTabPages(new DataTable(), new DataTable());
				}
			}
		}
		
		#endregion

		#region Public Methods

		/// <summary>
		/// DisplayTabPages
		/// </summary>
		/// <param name="SIs"></param>
		/// <param name="TRs"></param>
		private void DisplayTabPages(DataTable SIs, DataTable TRs)
		{
			// The tabs must be removed in a specific order, otherwise other controls lose focus;
			// seems the selected tab must be removed last.
			if (this.tabProfile.SelectedTab == this.pageSpecialInstructions)
			{
				if (this.tabProfile.TabPages.Contains(this.pageTransfusionRequirements))
				{
					this.tabProfile.TabPages.Remove(this.pageTransfusionRequirements);
				}
				//
				this.tabProfile.TabPages.Remove(this.pageSpecialInstructions);
			}
			else
			{
				if (this.tabProfile.TabPages.Contains(this.pageSpecialInstructions))
				{
					this.tabProfile.TabPages.Remove(this.pageSpecialInstructions);
				}
				//
				this.tabProfile.TabPages.Remove(this.pageTransfusionRequirements);
			}
			//
			bool addSIs, addTRs = false;
			//
			addSIs = ((SIs.Rows.Count > 0)&&(_patient.HasActiveSIs)&&(!this.tabProfile.TabPages.Contains(this.pageSpecialInstructions)));
			addTRs = ((TRs.Rows.Count > 0)&&(_patient.HasActiveTRs)&&(!this.tabProfile.TabPages.Contains(this.pageTransfusionRequirements)));
			//
			if (addTRs)
			{
				this.tabProfile.TabPages.Add(this.pageTransfusionRequirements);
				//
				// CR 2609
				this._hasTransfusionRequirementsTabData = true;
			}
			else
			{
				this._hasTransfusionRequirementsTabData = false;
			}
			//
			if (addSIs)
			{
				this.tabProfile.TabPages.Add(this.pageSpecialInstructions);
			}
			//
			this.tabProfile.Visible = (this.tabProfile.TabCount > 0);
		}

		/// <summary>
		/// LoadPanel
		/// </summary>
		/// <param name="specialInstruction"></param>
		/// <param name="transfusionRequirement"></param>
		/// <param name="divisionCode"></param>
		public void LoadPanel(DataTable specialInstruction, DataTable transfusionRequirement, string divisionCode)
		{
			this.LoadTransfusionRequirements(divisionCode, transfusionRequirement);
			this.LoadSpecialInstructions(specialInstruction);
			//
			DisplayTabPages(specialInstruction, transfusionRequirement);
		}

		/// <summary>
		/// Sets the height of pnlAntibodies/pnlAntigens and pnlComponentRequirements iff there 
		/// exists Transfusion Requirement data for the patient.
		/// If there are Antibody\Antigen Negative RBC and Component Requirements Data then
		/// the height of the panels is divided [approx.] equally.  
		/// Otherwise, we have either Antibody\Antigen Negative RBC or Component Requirements Data, 
		/// in which case we set the height to a [approx.] 75/25 ratio where the panel that has data
		/// gets 75% [approx.] of the available height.
		///
		/// CR 2609
		/// </summary>
		public void UpdateTransfusionRequirementsPanelHeight()
		{
			if ( this._hasTransfusionRequirementsTabData )
			{
				bool hasAntibodiesData = this.txtAntibodies.Text != null && this.txtAntibodies.Text != string.Empty;
				bool hasAntigenNegativeRBCsData = this.txtAntigenNegativeRBCs.Text != null && this.txtAntigenNegativeRBCs.Text != string.Empty;
				bool hasComponentRequirementsData = this.txtComponentRequirements.Text != null && this.txtComponentRequirements.Text != string.Empty;
				//
				if ( (hasAntibodiesData || hasAntigenNegativeRBCsData) && hasComponentRequirementsData )
				{
					int equalHeight = (this.Height >> 1) - 15;
					//
					this.pnlAntibodies.Height = equalHeight;
					this.pnlAntigens.Height = equalHeight;
					this.pnlComponentRequirements.Height = equalHeight;
				} 
				else
				{
					int quarterHeight = this.Height >> 2; 
					int oneQuarterHeight = quarterHeight; 
					int threeQuartersHeight = quarterHeight + quarterHeight + quarterHeight - 25;
					//
					if ( hasAntibodiesData || hasAntigenNegativeRBCsData )
					{
						this.pnlAntibodies.Height = threeQuartersHeight;
						this.pnlAntigens.Height = threeQuartersHeight;
						this.pnlComponentRequirements.Height = oneQuarterHeight;
					}
					else
					{
						this.pnlAntibodies.Height = oneQuarterHeight;
						this.pnlAntigens.Height = oneQuarterHeight;
						this.pnlComponentRequirements.Height = threeQuartersHeight;
					}
				}
			}
		}

		#endregion

		#region Private Methods

		/// <summary>
		/// Load the list of special instructions
		/// BR_36.01
		/// </summary>
		/// <param name="specialInstructions"></param>
		private void LoadSpecialInstructions(DataTable specialInstructions)
		{
			bool firstConversionRecord = true;

			if (specialInstructions.Rows.Count == 0 || !_patient.HasActiveSIs)
			{
				this.txtSpecialInstructions.Text = String.Empty;
				return;
			}
			this.txtSpecialInstructions.Text = String.Empty;
			
			DateTime previousDateTime = DateTime.MinValue;
			string previousUser = string.Empty;

			foreach (DataRow dr in specialInstructions.Rows)
			{
				DateTime dateTime = (DateTime) dr[TABLE.PatientSpecialInstruction.CreateDate];
				string date		= Common.VBECSDateTime.FormatDateTimeString(dateTime);
				
				string comment	= (string) dr[TABLE.PatientSpecialInstruction.PatientSpecialInstructions];

				string user		= string.Empty;
				string divisionCode = string.Empty; 
				
				Common.RecordStatusCode statusCode = Common.Utility.GetRecordStatusCodeFromString(dr[TABLE.PatientSpecialInstruction.RecordStatusCode].ToString());
				if (statusCode != Common.RecordStatusCode.Active && statusCode != Common.RecordStatusCode.Converted) continue;

				bool vistaConversionIndicator = (bool) dr[TABLE.PatientSpecialInstruction.VistaConversionIndicator];
				if (!vistaConversionIndicator)
				{
					user = (string) dr[TABLE.PatientSpecialInstruction.CreateUser];
					divisionCode = (string) dr[TABLE.PatientSpecialInstruction.DivisionCode];
				}

				// Displaying BR_36.01 SI Comments are part of the Patient BOL
				string si = string.Empty;
				if (vistaConversionIndicator == true)
				{
					if (firstConversionRecord)
					{
						si = "\n\nVistA Converted:\n " + comment; 
						firstConversionRecord = false;
					}
					else
					{
						si = "\n" + comment;
					}
				}
				else
				{
					if (dateTime.Year == previousDateTime.Year &&
						dateTime.Month == previousDateTime.Month &&
						dateTime.Day == previousDateTime.Day &&
						dateTime.Hour == previousDateTime.Hour &&
						dateTime.Minute == previousDateTime.Minute &&
						user.Equals(previousUser))
					{
						si = "\n " + comment;
					}
					else
					{
						if (this.txtSpecialInstructions.Text.Trim().Length > 0) this.txtSpecialInstructions.AppendText("\n\n");
						si = date + ", " + (new BOL.VbecsUser(user)).UserInitials + ", " + divisionCode.Trim() + ":\n " + comment;
					}
				}
				this.txtSpecialInstructions.AppendText(si);

				previousDateTime = dateTime;
				previousUser = user;
			}
		}

		/// <summary>
		/// Loads the list of transfusion requirements
		/// BR_38.10
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="transfusionRequirements"></param>
		private void LoadTransfusionRequirements(string divisionCode, DataTable transfusionRequirements)
		{
			bool firstConversionRecord = true;

			if (divisionCode == null)
			{
				throw new BOL.BusinessObjectException("You must set the Division Property before on the SI/TR Display Pane before using");
			}
			ArrayList duplicateComments = new ArrayList();

			this.txtComponentRequirements.Text = String.Empty;
			this.txtAntigenNegativeRBCs.Text = String.Empty;
			this.txtAntibodies.Text = String.Empty;

			if (transfusionRequirements.Rows.Count == 0 || !_patient.HasActiveTRs)
			{
				return;
			}

			DateTime currentDate = DateTime.MinValue; 
			DateTime previousDate = DateTime.MinValue;
			int categoryCode = 0;
			int previousCategoryCode = 0;
			string previousDivisionCode = string.Empty;

			foreach (DataRow dr in transfusionRequirements.Rows)
			{
				string user		= string.Empty;
				string createDivisionCode = string.Empty; 

				Common.TransfusionRequirementCategoryCode catCode = Common.Utility.GetTransfusionCategoryCodeFromString(dr[TABLE.PatientTransfusionRequirement.TransfusionRequirementCategoryCode].ToString());

				if (catCode != Common.TransfusionRequirementCategoryCode.ComponentRequirement &&
					!dr.IsNull(TABLE.AntibodyType.AntibodyTypeId) &&
					(!(bool)dr[TABLE.PatientTransfusionRequirement.VistaConversionIndicator] &&
					System.Enum.IsDefined(typeof(Common.ExcludedAntibodies), (int) dr[TABLE.AntibodyType.AntibodyTypeId]))) continue;

				currentDate = (DateTime) dr[TABLE.PatientTransfusionRequirement.CreateDate];
				string date		= Common.VBECSDateTime.FormatDateTimeString(currentDate);
				string comment	= (string) dr[TABLE.PatientTransfusionRequirement.TransfusionRequirementText];
				
				Common.RecordStatusCode statusCode = Common.Utility.GetRecordStatusCodeFromString(dr[TABLE.PatientTransfusionRequirement.RecordStatusCode].ToString());
				bool vistaConversionIndicator = (bool) dr[TABLE.PatientTransfusionRequirement.VistaConversionIndicator];
				if (statusCode != Common.RecordStatusCode.Active && statusCode != Common.RecordStatusCode.Converted) continue;

				string tr = string.Empty;
								
				// used for text formatting
				if (catCode == Common.TransfusionRequirementCategoryCode.ComponentRequirement) categoryCode = 1;
				else if (catCode == Common.TransfusionRequirementCategoryCode.AntigenNegative) categoryCode = 2;
				else categoryCode = 3;

				if (vistaConversionIndicator == true)
				{
					if (firstConversionRecord)
					{
						if (txtAntibodies.Text == string.Empty)
						{
							tr = "VistA Converted:\n " + comment; 
						}
						else
						{
							tr = "\n\nVistA Converted:\n " + comment; 
						}
						firstConversionRecord = false;
						// Converted TRs can only be Antibody Reqs:
						categoryCode = 3;
					}
					else
					{
						tr = "\n" +comment;
					}
					this.txtAntibodies.AppendText(tr);
				}
				else
				{
					user		= (string) dr[TABLE.PatientTransfusionRequirement.CreateUser];
					createDivisionCode = (string) dr[TABLE.PatientTransfusionRequirement.CreateDivisionCode];

					if (currentDate.Year == previousDate.Year &&
						currentDate.Month == previousDate.Month &&
						currentDate.Day == previousDate.Day &&
						currentDate.Hour == previousDate.Hour &&
						currentDate.Minute == previousDate.Minute &&
						categoryCode == previousCategoryCode && 
						createDivisionCode.Equals(previousDivisionCode))
					{
						// Displaying BR_36.02 TRs are part of the Patient BOL
						switch (catCode)
						{
							case (Common.TransfusionRequirementCategoryCode.ComponentRequirement):
								if (!duplicateComments.Contains(comment + createDivisionCode))
								{
									tr = "\n " + comment; 
									this.txtComponentRequirements.AppendText(tr);
									duplicateComments.Add(comment + createDivisionCode);
									categoryCode = 1;
								}
								break;
							case (Common.TransfusionRequirementCategoryCode.AntigenNegative):
								if (!duplicateComments.Contains(comment))
								{
									tr = comment + "\n";
									this.txtAntigenNegativeRBCs.AppendText(tr);
									duplicateComments.Add(comment);
									categoryCode = 2;
								}
								break;
								// Displaying BR_36.03 TRs are part of the Patient BOL
							case (Common.TransfusionRequirementCategoryCode.AntibodyIdentified):
								if (!duplicateComments.Contains(comment + createDivisionCode))
								{
									tr = "\n " + comment;
									this.txtAntibodies.AppendText(tr);
									duplicateComments.Add(comment + createDivisionCode);
									categoryCode = 3;
								}
								break;
						}
					}
					else
					{
						// Displaying BR_36.02 TRs are part of the Patient BOL
						switch (catCode)
						{
							case (Common.TransfusionRequirementCategoryCode.ComponentRequirement):
								if (this.txtComponentRequirements.Text.Trim().Length > 0) this.txtComponentRequirements.AppendText("\n\n");
								if (!duplicateComments.Contains(comment + createDivisionCode)) 
								{
									tr = date + ", " + (new BOL.VbecsUser(user)).UserInitials + ", " + createDivisionCode.Trim() + ":\n " + comment; 
									this.txtComponentRequirements.AppendText(tr);
									duplicateComments.Add(comment + createDivisionCode);
									categoryCode = 1;
								}
								break;
							case (Common.TransfusionRequirementCategoryCode.AntigenNegative):
								if (!duplicateComments.Contains(tr))
								{
									tr = comment + "\n";
									this.txtAntigenNegativeRBCs.AppendText(tr);
									duplicateComments.Add(comment);
									categoryCode = 2;
								}
								break;
								// Displaying BR_36.03 TRs are part of the Patient BOL
							case (Common.TransfusionRequirementCategoryCode.AntibodyIdentified):
								if (this.txtAntibodies.Text.Trim().Length > 0) this.txtAntibodies.AppendText("\n\n");
								if (!duplicateComments.Contains(comment + createDivisionCode)) 
								{
									tr = date + ", " + (new BOL.VbecsUser(user)).UserInitials + ", " + createDivisionCode.Trim() + ":\n " + comment;
									this.txtAntibodies.AppendText(tr);
									duplicateComments.Add(comment + createDivisionCode);
									categoryCode = 3;
								}
								break;
						}
					}
					previousDate = currentDate;
					previousDivisionCode = createDivisionCode;
					previousCategoryCode = categoryCode;
				}
			}
			
			#region System generated Antigen Negative reqs

			// Calling BR_38.10 - System generated antigen negative requirements
			DataTable dt = BOL.AntibodyType.GetAntibodyTypeLookupList();
			DataTable dtAntibodyType		= BOL.AntibodyType.GetAntibodyType();
			
			foreach (DataRow dr in transfusionRequirements.Rows)
			{
	
				// Get antibody TRs
				Common.TransfusionRequirementCategoryCode catCode = Common.Utility.GetTransfusionCategoryCodeFromString(dr[TABLE.PatientTransfusionRequirement.TransfusionRequirementCategoryCode].ToString());
				Common.RecordStatusCode statusCode = Common.Utility.GetRecordStatusCodeFromString(dr[TABLE.PatientTransfusionRequirement.RecordStatusCode].ToString());

				if (catCode != Common.TransfusionRequirementCategoryCode.AntibodyIdentified ||
					(statusCode != Common.RecordStatusCode.Active &&
					statusCode != Common.RecordStatusCode.Converted) ||
					// Ignore these (from TT_23.01C)
					System.Enum.IsDefined(typeof(Common.ExcludedAntibodies), (int) dr[TABLE.AntibodyType.AntibodyTypeId])) continue;
			
				int antibodyTypeID = (int) dr[TABLE.AntibodyType.AntibodyTypeId];
				DataRow [] dtAntibodyTypes = dtAntibodyType.Select(TABLE.AntibodyType.AntibodyTypeId + " = " + antibodyTypeID);
				if (dtAntibodyTypes.Length > 0)
				{
					string antibodyTypeName = (string) dtAntibodyTypes[0][TABLE.AntibodyType.AntibodyTypeName];

					string filter = TABLE.AntibodyType.AntibodyTypeId + " = " + antibodyTypeID + " AND " + TABLE.AntibodyParameter.HigherLevelOverrideIndicator + " = 1";
					DataRow[] dtOverride = dt.Select(filter);

					if (dtOverride.Length > 0)
					{
						DataRow [] dtAntNegs = dtAntibodyType.Select(TABLE.AntibodyType.AntibodyTypeName + " = '" + dtOverride[0][TABLE.AntibodyType.AntibodyTypeName] + "'");

						foreach (DataRow dtRow in dtAntNegs)
						{
							if ( !dtRow.IsNull(TABLE.AntigenType.AntigenTypeName) 
								&& !dtRow[TABLE.AntigenType.AntigenTypeName].ToString().ToUpper().Equals("none")
								&& dtRow[TABLE.AntibodyType.AntibodyTypeName].ToString() == antibodyTypeName)
							{
								if (duplicateComments.Contains( dtRow[TABLE.AntigenType.AntigenTypeName].ToString().Trim() )) continue;
								string tr = dtRow[TABLE.AntigenType.AntigenTypeName].ToString() + "\n";
								this.txtAntigenNegativeRBCs.AppendText(tr);
								duplicateComments.Add( dtRow[TABLE.AntigenType.AntigenTypeName].ToString().Trim() );
							}
						}
					}
				}
			}

			#endregion
		}

		#endregion
	}
}
